<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Lecon extends Model 
{

    protected $table = 'lecons';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function honoraires()
    {
        return $this->morphToMany('App\Models\Honoraires', 'honoraireable');
    }

    public function achats()
    {
        return $this->belongsTo('App\Models\Achat');
    }

    public function horaires()
    {
        return $this->belongsTo('App\Models\Horaires');
    }

}